<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'trial_balance'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'trial_balance'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'trial_balance'); ?></h2>
                    
                    <form id="financial-balance-sheet-search-form" action="<?= url('/trial-balance'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 25%;"><?= print_lang($app_lang,'trial_balance_table_1st_head'); ?></th>
                                    <th style="width: 25%; text-align: center;"><?= print_lang($app_lang,'trial_balance_table_2nd_head'); ?></th>
                                    <th style="width: 25%; text-align: center;"><?= print_lang($app_lang,'trial_balance_table_3rd_head'); ?></th>
                                    <th style="width: 25%; text-align: center;"><?= print_lang($app_lang,'trial_balance_table_4th_head'); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php
                                $tr_debits = array();
                                $tr_credits = array();
                                $branch_id = active_branch_id();
                                $branches_for_query = array();
                                $currency_for_query = array();
                                ?>

                                <?php 
                                foreach($root_accounts as $racount){
                                    $debits = 0;
                                    $credits = 0;
                                    $balance = 0;
                                    $debits_shared = 0;
                                    $credits_shared = 0;
                                    $total_debits = 0;
                                    $total_credits = 0;
                                    if($racount['branch'] == 'general')
                                    {
                                        $parent_name = print_lang($app_lang,'builtin_account_'.$racount['uid']);
                                    }
                                    else
                                    {
                                        $parent_name = $racount['name'];
                                    }

                                    $currency = $search_currency;
                                    $currency_data = fetch_table_where('currency','uid',$currency,true);
                                    $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency_data['branch_equalance'])->pluck('uid')->toArray());
                                    $shared_uids_accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type',$racount['uid'])->pluck('uid')->toArray());

                                    $debits = DB::table('accounts_ledger')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$racount['uid'])->sum('debit');
                                    $credits = DB::table('accounts_ledger')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$racount['uid'])->sum('credit');
                                    $balance = (float)$debits - (float)$credits;

                                    // if($racount['uid'] == 'cashbook')
                                    // {
                                    //     $cashbooks = fetch_all_cashbooks();
                                    //     $debits_array = array();
                                    //     $credits_array = array();
                                    //     foreach($cashbooks as $cashbook)
                                    //     {
                                    //         if($cashbook['shared'] == 'yes')
                                    //         {
                                    //             // get shared account data
                                    //             $currency_data = fetch_table_where('currency','uid',$search_currency,true);
                                    //             $shared_currencies = fetch_table_where('currency','branch_equalance',$currency_data['branch_equalance']);
                                    //             $ledger_balance = DB::table('accounts_ledger')->select(DB::raw('sum(debit) - sum(credit) as balance , sum(debit) as debit, sum(credit) as credit'))->where('account_uid',$cashbook['uid'])->where(function($query) use ($search_currency,$shared_currencies)
                                    //             { 
                                    //                 $query->where('currency',$search_currency);
                                    //                 foreach($shared_currencies as $s_currency)
                                    //                 {
                                    //                     $query->orWhere('currency',$s_currency['uid']);
                                    //                 }
                                    //             })->where('account_type','cashbook');
                                    //             if(!empty($search_from)){ $ledger_balance->where('created_at','>=',get_true_date($search_from).' 00:00:00'); }
                                    //             if(!empty($search_to)){ $ledger_balance->where('created_at','<=',get_true_date($search_to).' 23:59:59'); }
                                    //             $ledger_balance = $ledger_balance->get()->first();

                                    //             $debits_array[] = $ledger_balance->debit;
                                    //             $credits_array[] = $ledger_balance->credit;
                                    //         }
                                    //         else
                                    //         {
                                    //             // get no shared account data
                                    //             $ledger_balance = DB::table('accounts_ledger')->select(DB::raw('sum(debit) - sum(credit) as balance , sum(debit) as debit, sum(credit) as credit'))->where('account_uid',$cashbook['uid'])->where('currency',$search_currency)->where('branch',$branch_id)->where('account_type','cashbook');
                                    //             if(!empty($search_from)){ $ledger_balance->where('created_at','>=',get_true_date($search_from).' 00:00:00'); }
                                    //             if(!empty($search_to)){ $ledger_balance->where('created_at','<=',get_true_date($search_to).' 23:59:59'); }
                                    //             $ledger_balance = $ledger_balance->get()->first();

                                    //             $debits_array[] = $ledger_balance->debit;
                                    //             $credits_array[] = $ledger_balance->credit;
                                    //         }

                                    //         $debits = array_sum($debits_array);
                                    //         $credits = array_sum($credits_array);
                                    //         $balance = (float)$debits - (float)$credits;
                                    //     }
                                    // }
                                    // else if($racount['uid'] == 'client')
                                    // {
                                    //     $clients = fetch_all_clients();
                                    //     $debits_array = array();
                                    //     $credits_array = array();
                                    //     foreach($clients as $client)
                                    //     {
                                    //         if($client['shared'] == 'yes')
                                    //         {
                                    //             // get shared account data
                                    //             $currency_data = fetch_table_where('currency','uid',$search_currency,true);
                                    //             $shared_currencies = fetch_table_where('currency','branch_equalance',$currency_data['branch_equalance']);
                                    //             $ledger_balance = DB::table('accounts_ledger')->select(DB::raw('sum(debit) - sum(credit) as balance , sum(debit) as debit, sum(credit) as credit'))->where('account_uid',$client['uid'])->where(function($query) use ($search_currency,$shared_currencies)
                                    //             { 
                                    //                 $query->where('currency',$search_currency);
                                    //                 foreach($shared_currencies as $s_currency)
                                    //                 {
                                    //                     $query->orWhere('currency',$s_currency['uid']);
                                    //                 }
                                    //             })->where('account_type','client');
                                    //             if(!empty($search_from)){ $ledger_balance->where('created_at','>=',get_true_date($search_from).' 00:00:00'); }
                                    //             if(!empty($search_to)){ $ledger_balance->where('created_at','<=',get_true_date($search_to).' 23:59:59'); }
                                    //             $ledger_balance = $ledger_balance->get()->first();

                                    //             $debits_array[] = $ledger_balance->debit;
                                    //             $credits_array[] = $ledger_balance->credit;
                                    //         }
                                    //         else
                                    //         {
                                    //             // get no shared account data
                                    //             $ledger_balance = DB::table('accounts_ledger')->select(DB::raw('sum(debit) - sum(credit) as balance , sum(debit) as debit, sum(credit) as credit'))->where('account_uid',$client['uid'])->where('currency',$search_currency)->where('branch',$branch_id)->where('account_type','client');
                                    //             if(!empty($search_from)){ $ledger_balance->where('created_at','>=',get_true_date($search_from).' 00:00:00'); }
                                    //             if(!empty($search_to)){ $ledger_balance->where('created_at','<=',get_true_date($search_to).' 23:59:59'); }
                                    //             $ledger_balance = $ledger_balance->get()->first();

                                    //             $debits_array[] = $ledger_balance->debit;
                                    //             $credits_array[] = $ledger_balance->credit;
                                    //         }

                                    //         $debits = array_sum($debits_array);
                                    //         $credits = array_sum($credits_array);
                                    //         $balance = (float)$debits - (float)$credits;
                                    //     }
                                    // }
                                    // else
                                    // {
                                    //     $debits = DB::table('accounts_ledger')->where('branch',$branch_id)->where('account_type',$racount['uid'])->where('currency',$search_currency)->sum('debit');
                                    //     $credits = DB::table('accounts_ledger')->where('branch',$branch_id)->where('account_type',$racount['uid'])->where('currency',$search_currency)->sum('credit');
                                    //     $balance = (float)$debits - (float)$credits;
                                    // }
                                ?>
                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= $parent_name; ?></td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($debits); $tr_debits[] = $debits; ?></td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($credits); $tr_credits[] = $credits; ?></td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($balance); ?></td>
                                    
                                </tr>
                                <?php } ?>
                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'trial_balance_table_fixed_assets'); ?></td>
                                    <?php
                                        $assets = DB::table('assets')->where('branch',active_branch_id())->where('currency',$currency)->sum('price');
                                    ?>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($assets); $tr_debits[] = $assets; ?></td>
                                    <td style="width: 25%; text-align: center;">0.00</td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format($assets); ?></td>
                                    
                                </tr>

                                <tr style="line-height: 35px;">
                                    <td style="width: 25%; text-indent: 20px;"><?= print_lang($app_lang,'total'); ?></td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format(array_sum($tr_debits)); ?></td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format(array_sum($tr_credits)); ?></td>
                                    <td style="width: 25%; text-align: center;"><?= amount_number_format(array_sum($tr_debits) - array_sum($tr_credits)); ?></td>
                                </tr>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>